# VYLO Authentication System

Simple email/password authentication for the VYLO MVP.

## Features

- Email/password authentication
- JWT-based sessions with HTTP-only cookies
- Password hashing with bcrypt
- Protected routes via middleware
- Login, signup, and logout functionality

## Files Created

### Auth Utilities
- `lib/auth.ts` - Core authentication functions (hashing, tokens, cookies)

### API Routes
- `app/api/auth/login/route.ts` - Login endpoint
- `app/api/auth/signup/route.ts` - Signup endpoint
- `app/api/auth/logout/route.ts` - Logout endpoint
- `app/api/auth/me/route.ts` - Get current user endpoint

### Pages
- `app/login/page.tsx` - Login form
- `app/signup/page.tsx` - Signup form

### Components
- `components/UserMenu.tsx` - User menu with logout

### Middleware
- `middleware.ts` - Route protection (redirects unauthorized users)

## Usage

### Sign Up
1. Navigate to `/signup`
2. Enter email, password, and optional name
3. Submit form
4. Automatically redirected to dashboard

### Login
1. Navigate to `/login`
2. Enter email and password
3. Submit form
4. Automatically redirected to dashboard

### Logout
1. Click on user avatar in dashboard header
2. Click "Sign out"
3. Automatically redirected to login page

## Protected Routes

The following routes require authentication:
- `/dashboard/*` - All dashboard routes

If a user tries to access a protected route without being logged in, they will be redirected to `/login`.

## Environment Variables

Add to your `.env` file:

```
JWT_SECRET="your-secret-key-here"
```

## Database Schema

The User model already exists in Prisma schema with:
- `id` (String, CUID)
- `email` (String, unique)
- `name` (String, optional)
- `password` (String, hashed)
- `plan` (Plan enum, default: FREE)
- `credits` (Int, default: 100)
- `createdAt` (DateTime)
- `updatedAt` (DateTime)

## Security Features

- Passwords are hashed with bcrypt (10 rounds)
- JWT tokens expire after 7 days
- HTTP-only cookies prevent XSS attacks
- Secure cookies in production
- SameSite=lax for CSRF protection

## Quick Test

1. Start the dev server: `npm run dev`
2. Visit `http://localhost:3000/signup`
3. Create an account
4. You'll be redirected to the dashboard
5. Try refreshing - you should stay logged in
6. Click logout - you'll be redirected to login

## Future Enhancements

For production, consider:
- Email verification
- Password reset flow
- Rate limiting on auth endpoints
- Session management (revoke tokens)
- OAuth providers (Google, GitHub, etc.)
- Two-factor authentication
