/**
 * @since 2.0.0
 */
import * as internal from "./internal/channel/upstreamPullRequest.js";
/**
 * @since 2.0.0
 * @category symbols
 */
export const UpstreamPullRequestTypeId = internal.UpstreamPullRequestTypeId;
/**
 * @since 2.0.0
 * @category constructors
 */
export const Pulled = internal.Pulled;
/**
 * @since 2.0.0
 * @category constructors
 */
export const NoUpstream = internal.NoUpstream;
/**
 * Returns `true` if the specified value is an `UpstreamPullRequest`, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
export const isUpstreamPullRequest = internal.isUpstreamPullRequest;
/**
 * Returns `true` if the specified `UpstreamPullRequest` is a `Pulled`, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
export const isPulled = internal.isPulled;
/**
 * Returns `true` if the specified `UpstreamPullRequest` is a `NoUpstream`,
 * `false` otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
export const isNoUpstream = internal.isNoUpstream;
/**
 * Folds an `UpstreamPullRequest<A>` into a value of type `Z`.
 *
 * @since 2.0.0
 * @category folding
 */
export const match = internal.match;
//# sourceMappingURL=UpstreamPullRequest.js.map