import type { CompoundHandler, PrimitiveHandler } from './types.js';
import type { ExplicitRule, ImplicitRule, Rule, MappedRule } from './types.js';
import type { Options, State } from './types.js';
declare const parse: <T>(input: string, rule: Rule<T>, options?: Options) => T[];
declare const validate: <T>(input: string, rule: Rule<T>, options?: Options) => boolean;
declare const match: <T>(target: RegExp | string | string[], handler?: PrimitiveHandler<T> | T) => ExplicitRule<T>;
declare const repeat: <T, U = T>(rule: Rule<T>, min: number, max: number, handler?: CompoundHandler<T, U>) => ExplicitRule<U>;
declare const optional: <T, U = T>(rule: Rule<T>, handler?: CompoundHandler<T, U>) => ExplicitRule<U>;
declare const star: <T, U = T>(rule: Rule<T>, handler?: CompoundHandler<T, U>) => ExplicitRule<U>;
declare const plus: <T, U = T>(rule: Rule<T>, handler?: CompoundHandler<T, U>) => ExplicitRule<U>;
declare const and: <T, U = T>(rules: (MappedRule<T> | Rule<T>)[], handler?: CompoundHandler<T, U>) => ExplicitRule<U>;
declare const or: <T, U = T>(rules: (MappedRule<T> | Rule<T>)[], handler?: CompoundHandler<T, U>) => ExplicitRule<U>;
declare const jump: <T, U = T>(rules: Record<string, Rule<T>>, handler?: CompoundHandler<T, U>) => ExplicitRule<U>;
declare const negative: <T>(rule: Rule<T>) => ExplicitRule<T>;
declare const positive: <T>(rule: Rule<T>) => ExplicitRule<T>;
declare const grammar: <T, U>(fn: (operators: {
    match: typeof match<T>;
    repeat: typeof repeat<T>;
    optional: typeof optional<T>;
    star: typeof star<T>;
    plus: typeof plus<T>;
    and: typeof and<T>;
    or: typeof or<T>;
    jump: typeof jump<T>;
    negative: typeof negative<T>;
    positive: typeof positive<T>;
    lazy: typeof lazy<T>;
}) => U) => U;
declare const lazy: <T = any>(getter: Function) => ExplicitRule<T>;
export { parse, validate };
export { match };
export { repeat, optional, star, plus };
export { and };
export { or, jump };
export { negative, positive };
export { grammar, lazy };
export type { CompoundHandler, PrimitiveHandler, ExplicitRule, ImplicitRule, Rule, Options, State };
