import type { Config } from "tailwindcss";

const config: Config = {
  content: [
    "./pages/**/*.{js,ts,jsx,tsx,mdx}",
    "./components/**/*.{js,ts,jsx,tsx,mdx}",
    "./app/**/*.{js,ts,jsx,tsx,mdx}",
  ],
  theme: {
    extend: {
      colors: {
        vylo: {
          dark: "#0a0a0f",
          darker: "#050507",
          primary: "#00f0ff",
          secondary: "#ff00ff",
          accent: "#7b2ff7",
          success: "#00ff88",
          warning: "#ffaa00",
          error: "#ff0055",
          purple: {
            50: "#f5f3ff",
            100: "#ede9fe",
            200: "#ddd6fe",
            300: "#c4b5fd",
            400: "#a78bfa",
            500: "#8b5cf6",
            600: "#7b2ff7",
            700: "#6b21a8",
            800: "#5b21b6",
            900: "#4c1d95",
          },
        },
      },
      backgroundImage: {
        "gradient-radial": "radial-gradient(var(--tw-gradient-stops))",
        "gradient-conic": "conic-gradient(from 180deg at 50% 50%, var(--tw-gradient-stops))",
        "vylo-gradient": "linear-gradient(135deg, #7b2ff7 0%, #00f0ff 100%)",
        "vylo-gradient-dark": "linear-gradient(135deg, #1a0b2e 0%, #0f1729 100%)",
      },
      animation: {
        "pulse-slow": "pulse 4s cubic-bezier(0.4, 0, 0.6, 1) infinite",
        "glow": "glow 2s ease-in-out infinite alternate",
        "float": "float 6s ease-in-out infinite",
      },
      keyframes: {
        glow: {
          "0%": { boxShadow: "0 0 5px #7b2ff7, 0 0 10px #7b2ff7" },
          "100%": { boxShadow: "0 0 20px #7b2ff7, 0 0 30px #7b2ff7, 0 0 40px #7b2ff7" },
        },
        float: {
          "0%, 100%": { transform: "translateY(0px)" },
          "50%": { transform: "translateY(-20px)" },
        },
      },
    },
  },
  plugins: [],
};

export default config;
