// Core VYLO Types

export interface Project {
  id: string;
  name: string;
  description: string;
  status: "planning" | "designing" | "developing" | "testing" | "deploying" | "deployed";
  progress: number;
  createdAt: Date;
  updatedAt: Date;
  owner: string;
  aiAgents: AIAgent[];
  sections: ProjectSection[];
}

export interface AIAgent {
  id: string;
  name: string;
  type: "code" | "design" | "marketing" | "testing" | "deployment";
  status: "idle" | "working" | "completed" | "error";
  currentTask?: string;
  provider: "claude" | "gpt4" | "dalle" | "midjourney" | "cursor" | "meshy";
  progress: number;
  lastActivity: Date;
}

export interface ProjectSection {
  id: string;
  type: "logo" | "icons" | "graphics" | "marketing" | "wireframe" | "code" | "testing" | "deployment";
  status: "pending" | "in-progress" | "completed" | "blocked";
  assignedAgent?: string;
  assets: Asset[];
  progress: number;
}

export interface Asset {
  id: string;
  name: string;
  type: "image" | "code" | "document" | "video" | "3d-model";
  url: string;
  createdBy: string; // AI agent ID
  createdAt: Date;
  version: number;
}

export interface User {
  id: string;
  email: string;
  name: string;
  plan: "free" | "pro" | "enterprise";
  credits: number;
  projects: Project[];
  createdAt: Date;
}

export interface Task {
  id: string;
  projectId: string;
  title: string;
  description: string;
  status: "todo" | "in-progress" | "review" | "done";
  priority: "low" | "medium" | "high" | "urgent";
  assignedTo: string; // AI agent ID or user ID
  createdAt: Date;
  completedAt?: Date;
  dependencies: string[]; // Task IDs
}
